function ShowPeak(handles)
%% Get handles
Energies  = get(handles.ZLPAlign,'UserData');
Length    = size(Energies,2);
PeakNo    = get(handles.PeakNo,'Value');
ZLPs      = get(handles.LoadPeak,'UserData');

switch PeakNo
    case 1
        FWHM = load(fullfile(tempdir,'ZLP1.mat')).ZLPFWHM;
        ZLP  = ZLPs{1,1};
        ZLP2 = ZLPs{2,1};
        
        if ~isempty(ZLP2)
            OtherZLP = ZLP2;
        else
            OtherZLP = [];
        end
    case 2
        FWHM  = load(fullfile(tempdir,'ZLP2.mat')).ZLPFWHM;
        ZLP1  = ZLPs{1,1};
        ZLP   = ZLPs{2,1};
        
        if ~isempty(ZLP1)
            OtherZLP = ZLP1;
        else
            OtherZLP = [];
        end
end

%% Plot
if isempty(OtherZLP)
    
    %% Fitting
    % It might be usefull to see how good the ZLP can be fitted via Gauss or Fowler-Nordheim.
    % Thus it is calculated and plotted here
    options     = optimset('Display','off');
    sigma       = mean(FWHM,'all')./(2*sqrt(2.*log(2)));
    
    %% Gauss
    x           = [ 1 , 0 ,sigma, 10^(-5)];
    eqn         = @(x) sum((x(1).*exp(-((Energies-x(2))./(sqrt(2).*x(3))).^2)+x(4) - ZLP(1,1:Length)).^2);
    x           = fminsearch(eqn,x,options);
    Gauss       = x(1).*exp(-((Energies-x(2))./(sqrt(2).*x(3))).^2);
    
    %% Fowler-Nordheim
    x           = [ 1 , 0 , 0.4, 0.0825];
    eqn         = @(x) sum((x(1).*exp(-(Energies-x(2))./abs(x(3)))./(1+exp(-(Energies-x(2))./abs(x(4)))) - ZLP(1,1:Length)).^2);
    x           = fminsearch(eqn,x,options);
    FN          = x(1).*exp(-(Energies-x(2))./abs(x(3)))./(1+exp(-(Energies-x(2))./abs(x(4))));
    
    figure('Name','Comparisson of Normed ZLP with Fits');
    plot(Energies,ZLP(1,1:Length),Energies,FN,Energies,Gauss,'LineWidth',1.5);
    switch PeakNo
        case 1
            lgd=legend('ZLP 1','Fowler Fit','Gauss Fit');
        case 2
            lgd=legend('ZLP 2','Fowler Fit','Gauss Fit');
    end
    xlim([-5*mean(FWHM,'all'),5*mean(FWHM,'all')])
    ylabel( 'Normed Counts [a.u.]' );
    xlabel( 'Loss energy [eV]' )
    set(gca,'FontSize',18);
    lgd.FontSize = 9;
else
    
    figure('Name','Comparisson of both Normed ZLP!');
    plot(Energies,ZLP(1,1:Length),Energies,OtherZLP(1,1:Length),'LineWidth',1.5);
    switch PeakNo
        case 1
            lgd2=legend('ZLP 1','ZLP 2');
        case 2
            lgd2=legend('ZLP 2','ZLP 1');
    end
    xlim([-5*mean(FWHM,'all'),5*mean(FWHM,'all')])
    ylabel( 'Normed Counts [a.u.]' );
    xlabel( 'Loss energy [eV]' )
    set(gca,'FontSize',18);
    lgd2.FontSize = 9;
    
end
clearvars all
end